/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin.utils;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import me.towdium.pinin.PinIn;
import me.towdium.pinin.elements.Char;
import me.towdium.pinin.elements.Pinyin;
import me.towdium.pinin.utils.IndexSet;

public class Accelerator {
    final PinIn context;
    List<IndexSet.Storage> cache;
    char[] searchChars;
    String searchStr;
    Provider provider;
    Str str = new Str();
    boolean partial;

    public Accelerator(PinIn context) {
        this.context = context;
    }

    public void search(String s) {
        if (!s.equals(this.searchStr)) {
            this.searchStr = s;
            this.searchChars = s.toCharArray();
            this.reset();
        }
    }

    public IndexSet get(char ch, int offset) {
        Char c = this.context.getChar(ch);
        IndexSet ret = (this.searchChars[offset] == c.get() ? IndexSet.ONE : IndexSet.NONE).copy();
        for (Pinyin p : c.pinyins()) {
            ret.merge(this.get(p, offset));
        }
        return ret;
    }

    public IndexSet get(Pinyin p, int offset) {
        for (int i = this.cache.size(); i <= offset; ++i) {
            this.cache.add(new IndexSet.Storage());
        }
        IndexSet.Storage data = this.cache.get(offset);
        IndexSet ret = data.get(p.id);
        if (ret == null) {
            ret = p.match(this.searchStr, offset, this.partial);
            data.set(ret, p.id);
        }
        return ret;
    }

    public void setProvider(Provider p) {
        this.provider = p;
    }

    public void setProvider(String s) {
        this.str.s = s;
        this.provider = this.str;
    }

    public void reset() {
        this.cache = new ObjectArrayList();
    }

    public boolean check(int offset, int start) {
        if (offset == this.searchStr.length()) {
            return this.partial || this.provider.end(start);
        }
        if (this.provider.end(start)) {
            return false;
        }
        IndexSet s = this.get(this.provider.get(start), offset);
        if (this.provider.end(start + 1)) {
            int i2 = this.searchStr.length() - offset;
            return s.get(i2);
        }
        return !s.traverse(i -> !this.check(offset + i, start + 1));
    }

    public boolean matches(int offset, int start) {
        if (this.partial) {
            this.partial = false;
            this.reset();
        }
        return this.check(offset, start);
    }

    public boolean begins(int offset, int start) {
        if (!this.partial) {
            this.partial = true;
            this.reset();
        }
        return this.check(offset, start);
    }

    public boolean contains(int offset, int start) {
        if (!this.partial) {
            this.partial = true;
            this.reset();
        }
        int i = start;
        while (!this.provider.end(i)) {
            if (this.check(offset, i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String search() {
        return this.searchStr;
    }

    public int common(int s1, int s2, int max) {
        int i = 0;
        while (i < max) {
            char b;
            char a = this.provider.get(s1 + i);
            if (a != (b = this.provider.get(s2 + i)) || a == '\u0000') {
                return i;
            }
            ++i;
        }
        return max;
    }

    static class Str
    implements Provider {
        String s;

        Str() {
        }

        @Override
        public boolean end(int i) {
            return i >= this.s.length();
        }

        @Override
        public char get(int i) {
            return this.s.charAt(i);
        }
    }

    public static interface Provider {
        public boolean end(int var1);

        public char get(int var1);
    }
}

